/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.lib.compat.crt.base;

import cofh.lib.fluid.FluidIngredient;
import cofh.thermal.lib.compat.crt.base.CRTHelper;
import cofh.thermal.lib.util.recipes.ThermalFuel;
import com.blamejared.crafttweaker.api.fluid.CTFluidIngredient;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.ingredient.IIngredientWithAmount;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;

public class CRTFuel {
    private final ResourceLocation name;
    private final int energy;
    private List<Ingredient> item;
    private List<FluidIngredient> fluid;

    public CRTFuel(ResourceLocation name, int energy) {
        this.name = name;
        this.energy = energy;
    }

    public CRTFuel item(IIngredientWithAmount item) {
        this.item = Collections.singletonList(CRTHelper.mapIIngredientWithAmount(item));
        return this;
    }

    public CRTFuel item(List<Ingredient> newIngredients) {
        this.item = newIngredients;
        return this;
    }

    public CRTFuel fluid(CTFluidIngredient fluid) {
        this.fluid = Collections.singletonList(CRTHelper.mapFluidIngredient(fluid));
        return this;
    }

    public CRTFuel fluid(IFluidStack fluid) {
        this.fluid = Collections.singletonList(FluidIngredient.of((FluidStack[])new FluidStack[]{fluid.getInternal()}));
        return this;
    }

    public <T extends ThermalFuel> T fuel(IFuelBuilder<T> builder) {
        return builder.apply(this.name, this.energy, this.item, this.fluid);
    }

    public static interface IFuelBuilder<T extends ThermalFuel> {
        public T apply(ResourceLocation var1, int var2, @Nullable List<Ingredient> var3, @Nullable List<FluidIngredient> var4);
    }
}

